'use server'

import { cookies } from "next/headers";
import { createAccount, nidLogin, profApplication, profLogin, studentLogin } from "./app";
import { redirect } from "next/navigation";


export async function test(data, formData) {
    const { first_name, last_name, email, stream, o_level } = Object.fromEntries(data);
console.log(formData, 'formData')
    console.log(data, 'data with file')
    console.log(o_level)
    console.log(o_level.kHandle)
}

export async function create(data) {
    const { first_name, last_name, email, stream } = Object.fromEntries(data);

    if (!first_name || !last_name || !email || !stream) throw new Error('Invalid input');

    const create = await createAccount({ first_name, last_name, email, stream });

    if (!create) throw new Error('Failed to create account');

    redirect('/aspirant/professional/create/success')

    // revalidatePath('/professional/create');
}

export const pLogin = async (data) => {
    const { email, password } = Object.fromEntries(data);

    if (!email || !password) throw new Error('Invalid input');

    const res = await profLogin({ email, password });
    // console.log(res)
    if (!res) throw new Error('Failed to login');

    cookies().set('prof_aspirant', res.data.token)
    // cookies().set('prof_aspirant', JSON.stringify({ token: res.data.token, data: res.data.aspirant }))

    redirect('/aspirant/professional')
}

export const pApplication = async (data) => {
    const { middle_name, email, DOB, workplace, qualification, years_of_exp, stream } = Object.fromEntries(data);

    if (!middle_name || !email || !DOB || !workplace || !qualification || !years_of_exp || !stream) throw new Error('Invalid input');

    const token = cookies().get('prof_aspirant')?.value
    const res = await profApplication(token, { middle_name, email, DOB, workplace, qualification, years_of_exp }, stream);
    // console.log(res)

    if (!res) throw new Error('Application failed');

    // const dt = JSON.parse(cookies().get('prof_aspirant')?.value).data
    // cookies().set('prof_aspirant', JSON.stringify({
    //     token,
    //     data: {
    //         ...dt,
    //         status: 'pending'
    //     }
    // }))

    redirect('/aspirant/professional')
}


// NID

export const nLogin = async (data) => {
    const { jamb_reg, password } = Object.fromEntries(data);

    if(!jamb_reg || !password) throw new Error('Invalid input');

    const res = await nidLogin({jamb_reg, password});

    if(!res) throw new Error('Login failed');

    cookies().set('aspirant', res.data.token);

    redirect('/aspirant/nid')
}


// Student

export const login = async (data) => {
    const { matric_no, password } = Object.fromEntries(data);
console.log(matric_no, password)
    if (!matric_no || !password) throw new Error('Invalid input');

    const res = await studentLogin({ matric_no, password });
    console.log(res)
    if (!res) throw new Error('Failed to login');

    cookies().set('student', res.data.token);

    redirect('/dashboard')
}