'use client'

import { useState } from 'react';
import ProfileCard from './ProfileCard';
import DocumentContent from './DocumentSection';

const TabSection = ({student, token}) => {
    const [activeTab, setActiveTab] = useState('profile');
    // Define tabs
    const tabs = [
        { id: 'profile', title: 'Profile', content: <ProfileCard student={student} /> },
        { id: 'data', title: 'Data', content: <DocumentContent token={token} /> },
    ];

    return (
        <div className="bg-white shadow rounded-lg mt-10">
            <ul className="flex border-b">
                {tabs.map(tab => (
                    <li key={tab.id} className="-mb-px mr-1">
                        <button
                            className={`inline-block py-2 px-4 font-semibold ${activeTab === tab.id ? 'text-orange-700 border-b-2 border-orange-500' : 'text-orange-500 hover:text-orange-800'}`}
                            onClick={() => setActiveTab(tab.id)}
                        >
                            {tab.title}
                        </button>
                    </li>
                ))}
            </ul>
            <div className="p-4 bg-orange-400">
                {tabs.find(tab => tab.id === activeTab)?.content}
            </div>
        </div>
    );
};

export default TabSection;
