import Image from "next/image";
import avatar from '@/app/img/avatar1.webp';

const ProfileCard = async({student}) => {
console.log(student)
    return (
        <div className="p-4 bg-orange-400 rounded-lg shadow-md">
            <div className="text-center">
                <div className="flex justify-center">
                    <Image src={avatar} alt="profile pic" className="w-24 h-24 rounded-full border-2 border-orange-500" />
                </div>
                <h2 className="mt-4 text-lg font-semibold text-orange-700">{student.last_name} {student.first_name} {student.middle_name}.</h2>
                <p className="text-orange-600">{student.email}</p>
            </div>
            <div className="mt-4">
                <div className="flex items-center justify-between">
                    <span className="text-sm font-bold text-gray-600">Level:</span>
                    <span className="text-sm font-bold text-gray-800">{student.level}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Programme:</span>
                    <span className="text-sm font-bold text-gray-800">{student.stream}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Admission number:</span>
                    <span className="text-sm font-bold text-gray-800">{student.adm_no}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Matric number:</span>
                    <span className="text-sm font-bold text-gray-800">{student.matric_no}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Date of Birth:</span>
                    <span className="text-sm font-bold text-gray-800">{student.DOB}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Phone Number:</span>
                    <span className="text-sm font-bold text-gray-800">{student.phone}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Gender</span>
                    <span className="text-sm font-bold text-gray-800">{student.gender.split('')[0].toUpperCase() + student.gender.slice(1)}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Enrollment Date:</span>
                    <span className="text-sm font-bold text-gray-800">{student.enrollment_date}</span>
                </div>
                <div className="flex items-center justify-between mt-2">
                    <span className="text-sm font-bold text-gray-600">Completion Date:</span>
                    <span className="text-sm font-bold text-gray-800">{student.completion_date}</span>
                </div>
            </div>
        </div>
    );
};

export default ProfileCard