// 'use client'

import { generateExamSlip, getAdmissionLetter } from "@/app/utils/app";
import { notify } from "@/app/utils/helper";

const downloadFile = async (token, fn) => {
    try {
        const {blob, filename} = await fn(token);
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.style.display = 'none';
        a.href = url;
        a.download = filename;
        document.body.appendChild(a);
        a.click();
        window.URL.revokeObjectURL(url);
    } catch (error) {
        notify('error', error)
        console.error('Download failed', error);
    }
};

const DocumentContent = ({token}) => {

    const handleDownload = (fn) => downloadFile(token, fn);
    
    return (
        <div className="p-4 bg-orange-400 rounded-lg shadow-md">
            <h2 className="text-lg font-semibold text-orange-700 mb-4">Documents</h2>
            <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
                <div className="border rounded-lg p-4 flex flex-col items-center justify-between">
                    <h3 className="font-medium text-gray-800">Admission letter.pdf</h3>
                    <p className="text-sm text-gray-600">Size: ...</p>
                    <button className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600" onClick={() => handleDownload(getAdmissionLetter)}>Download</button>
                </div>
                <div className="border rounded-lg p-4 flex flex-col items-center justify-between">
                    <h3 className="font-medium text-gray-800">Exam slip.pdf</h3>
                    <p className="text-sm text-gray-600">Size: ...</p>
                    <button className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600" onClick={() => handleDownload(generateExamSlip)}>Download</button>
                </div>
                <div className="border rounded-lg p-4 flex flex-col items-center justify-between">
                    <h3 className="font-medium text-gray-800">Receipts.pdf</h3>
                    <p className="text-sm text-gray-600">Size: ...</p>
                    <a href="#" download className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600">
                        Download
                    </a>
                </div>
                <div className="border rounded-lg p-4 flex flex-col items-center justify-between">
                    <h3 className="font-medium text-gray-800">Internship letter.pdf</h3>
                    <p className="text-sm text-gray-600">Size: ...</p>
                    <a href="#" download className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600">
                        Download
                    </a>
                </div>
            </div>
        </div>
    );
};

export default DocumentContent;