import React from 'react'
import Header from '../component/header'
import Profile from '../component/Profile'
import { getMe } from '../utils/app';
import { cookies } from 'next/headers';
import ButtomNav from '../component/ButtomNav';

const getToken = () => cookies().get('student')?.value;

const getProfile = async () => {
    const std = await getMe(getToken());

    return std.data
}

const layout = async ({ children }) => {
    const student = await getProfile();

    return (
        <div className='font-mono'>
            <Header background_color='bg-white' account_section={true} student={student} />
            <Profile student={student} />
            {/* <div className=' flex mt-20'> */}
            <div className='bg-gradient-to-b from-transparent via-rgb(var(--background-end-rgb)) to-rgb(var(--background-start-rgb)) pt-12 sm:ml-64 min-h-screen'>
                <div className='md:p-8'>
                    {/* <div className='z-10 absolute md:left-0 lg:left-80'> */}
                    <div className=''>
                        {/* <div className='z-10 absolute '> */}
                        <div className='flex flex-col sm:flex-row items-center justify-between sm:gap-2 mt-10'>
                            <div>
                                <h1 className=''>Date: {new Date().toLocaleDateString()}</h1>
                                {student.stream === 'full' || student.stream === 'part' && <h1 className=''>Level: {student.level} Level</h1>}

                            </div>
                            {/* <div className='lg:absolute md:-right-[1rem]'> */}
                            <div className=''>
                                <p> Session :  {student.current_session}</p>
                                {student.stream === 'full' || student.stream === 'part' && <p >Semester: First Semester</p>}
                                {student.stream !== 'full' && student.stream === 'part' && <h1 className=''>Diet: {student.diet}</h1>}
                            </div>
                        </div>
                        {/* <div className='border-b-2 border-black pt-6 w-0  lg:w-[73rem]'></div> */}
                        <div className='border-b-2 border-black-200 mt-6 w-full'></div>

                        {/* <div className='bg-orange-400'> */}
                        {children}
                        {/* </div> */}
                    </div>
                </div>
                <ButtomNav />
            </div>
        </div>
    )
}

export default layout