
import { getCourses, getFees, getMe } from '@/app/utils/app';
import { cookies } from 'next/headers';
import PayButton from './component/PayButton';

const getToken = () => cookies().get('student')?.value;

const fetchFees = async () => {
    const courses = await getFees(getToken())

    return courses.data
}

const page = async () => {
    const fees = await fetchFees()

    return (
        <div className='flex flex-col'>
            <div className=''>
                {/* FEE */}
                {/* <div className='container mx-auto mt-4'> */}
                {
                    !fees.length ?
                        (
                            <div className='container mx-auto mt-12'>
                            <h1 className='px-8 md:px-0'>You don't have any outstanding fee</h1>
                            </div>
                        )
                        :
                        (
                            <div>
                                <h1 className="text-3xl font-bold my-10">Fees</h1>
                                <div className='overflow-x-auto  max-h-[300px] shadow-md'>
                                    <table className="min-w-full  divide-y rounded-3 divide-gray-300 shadow-md">
                                        <thead className='bg-gray-300 m-3 p-3 sticky top-0 z-10'>
                                            <tr className='text-slate-500'>
                                                <th className="p-5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                                                <th className="px-20 md:px-10 lg:px-20 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                                <th className="text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody className='bg-orange-400  max-w-full divide-y divide-gray-300'>
                                            {fees.map((fee) => (
                                                <tr key={fee.id} className='text-slate-400 text-xs uppercase'>
                                                    <td className="p-7 whitespace-normal" ><input type="checkbox" name="" id="" className=' accent-orange-500 text-white checked:text-white' /></td>
                                                    <td className="px-20 md:px-10 lg:px-20 whitespace-normal">{fee.name}</td>
                                                    <td className="px-8 whitespace-normal">₦ {fee.amount}</td>
                                                </tr>
                                            ))}
                                        </tbody>

                                    </table>
                                </div>
                                {/* <button className='bg-orange-500 w-40  h-10 rounded-md text-white absolute right-0  mt-5'>Pay</button> */}
                            </div>

                        )
                }

                {/* </div> */}

            </div>
            {fees.length && <PayButton fees={fees} />}

        </div>
    )
}

export default page