import { IoMdClose } from "react-icons/io";
import { useState, useTransition } from "react";
import { payOutstandingFee } from "@/app/utils/app";
import cookies from 'js-cookie';
import { useRouter } from "next/navigation";

const Summary = ({ fees, onClose }) => {
    const [isPending, startTransition] = useTransition();
    const [error, setError] = useState('');
    const router = useRouter();

    const pay = async () => {
        const token = cookies.get('student');
        try {
            setError('');
            const res = await payOutstandingFee(token);
            console.log(res)
            router.replace(res.data);
        } catch (err) {
            console.error('Payment error:', err);
            setError('Payment failed due to an internal error. Please try again later.');
        }
    }

    return (
        <div>
            <div
                className={`fixed inset-0 flex items-center justify-center z-50 w-screen p-10 fade-in-regular`}
            >
                <div className="fixed inset-0 bg-black opacity-30"></div>
                <div className='flex justify-center items-center font-serif'>
                    <div className='shadow-sm rounded-sm relative shadow-black bg-white min-h-96 min-w-96 mt-48'>
                        <div className="justify-between items-center m-3">
                            <h1 className='text-center text-xl text-orange-900 font-bold'>Summary</h1>
                        </div>

                        <div className='pt-10 pl-8'>
                            <div className='flex gap-8 text-orange-900 '>
                                <div>
                                    {fees.map((fee, i) => (
                                        <div key={i} className="mb-2">
                                            <h3>{fee.name} :</h3>
                                        </ div>
                                    ))}
                                </div>
                                <div>
                                    {fees.map((fee, i) => (
                                        <p key={i} className="mb-2">{fee.amount}</p>
                                    ))}
                                </div>
                                {/* <input type='checkbox' name='split' onChange={(e) => setFeesToPay(prev => ({ ...prev, split: e.target.checked }))} /> partial payment
                                    <p className='text-xs'>You can choose to pay 60% of the school fee</p> */}
                            </div>
                            <h3 className='pt-12 font-bold'>Total:</h3>
                            <div className='border-b pt-10 w-80'></div>
                        </div>
                        {error && <div className="text-red-500">{error}</div>}
                        <div className='flex gap-4 absolute bottom-5 right-3'>
                            <button className='shadow-md w-32 h-10 rounded-md' onClick={onClose}>Cancel</button>
                            <button className='shadow-md w-32 h-10 rounded-md text-white bg-orange-500' onClick={() => startTransition(pay)}>{isPending ? 'Processing...' : 'Continue'}</button>
                        </div>
                    </div>
                </div>
                {/* </div> */}
            </div>
        </div>
    )
}

export default Summary