import Table from '@/app/component/Table';
import { getMe } from '@/app/utils/app';
import { cookies } from 'next/headers';

const getProfile = async () => {

    const cookie = cookies();
    const token = cookie.get('student')?.value
    const std = await getMe(token);

    return std.data
}


const page = async () => {
    const student = await getProfile()

    console.log(student)

    
    return (
        <div>
            <div className='flex flex-col '>
                <div>
                    {/* <div className=''>
                        <h1 className='md:text-2xl xs:text-lg pl-3 sm:pl-0 font-semibold mt-7 tracking-tighter'>Welcome {student.first_name} {student.last_name}</h1>
                    </div> */}

                    <div className='flex justify-between mt-8'>
                        <div className='bg-white shadow-sm shadow-orange-200 w-fit text-sm sm:text-sm md:text-lg lg:text-xl font-bold text-black rounded-lg p-3'>
                            {student.stream === 'full' || student.stream === 'part' && <h1 className=''>Level: {student.level}</h1>}
                            {student.stream !== 'full' && student.stream === 'part' && <h1 className=''>Diet: {student.diet}</h1>}
                        </div>
                        <div className='bg-white shadow-sm shadow-orange-200 right-2 w-fit text-xs sm:text-sm md:text-lg lg:text-xl font-bold text-black rounded-lg p-3'>
                            {student.stream === 'full' || student.stream === 'part' && <h1 className=''>NID Broadcast Journalism</h1>}
                            {student.stream !== 'full' && student.stream === 'part' && <h1 className='font-bold'>{student.stream.charAt(0).toUpperCase() + student.stream.slice(1)} Professional Certificate</h1>}
                        </div>
 
                    </div>

                </div>
            </div>
            <Table student={student} />
        </div>
    )
}

export default page