import Profile from '@/app/component/Profile';
import Header from '@/app/component/header';
import { getCourses, getMe } from '@/app/utils/app';
import { cookies } from 'next/headers';
import CourseList from '../component/CourseList';

const getToken = () => cookies().get('student')?.value;

const getProfile = async () => {
    const std = await getMe(getToken());

    return std.data
}

const fetchCourses = async (stream) => {
    const courses = await getCourses(getToken(), stream)

    return courses.data
}

const page = async () => {
    const student = await getProfile();
    console.log(student);
    const courses = await fetchCourses(student.stream)

    return (
        <div className='font-serif'>
            <div className=' flex mt-4'>
                <div className='max-h-screen'>
                    <div className=''>
                        <CourseList student={student} courses={courses} />
                    </div>
                </div>

            </div>
        </div>
    )
}

export default page