"use client"
import React, { useState } from 'react'
import { IoMdClose } from "react-icons/io";
import Preloader from '@/app/Preloader';
import { registerCourses } from '@/app/utils/app';
import cookies from 'js-cookie';
import { notify } from '@/app/utils/helper';


function CourseList({ student, DBtn, courses }) {

    const [Modal, setModal] = useState(false);
    const [selectedCourses, setSelectedCourses] = useState([]);


    const handleClickAdd = (course) => {
        if (!selectedCourses.find(c => c.id === course.id)) {
            setSelectedCourses((prevCourses) => [...prevCourses, course]);
        }
    };

    const handleClickCancel = (id) => {
        setSelectedCourses((prevCourses) =>
            prevCourses.filter((course) => course.id !== id)
        )
    };

    const handleRegister = async () => {
        try {
            const token = cookies.get('student');
            const ids = selectedCourses.map(course => course.id);
            const register = await registerCourses(token, ids);

            if (!register) throw new Error('Failed to register');

            notify('success', register.message);

            setSelectedCourses([])
        } catch (error) {
            console.log(error)
            if (error.response?.data?.errors) return notify('error', error.response.data.message)
            notify('error', error.message);
        }
    }

    return (
        <div>
            <div className=''>
                <div className='flex items-center justify-between mb-5'>
                    <h1 className={`text-3xl font-bold pb-5 pt-10`}>Course Registration</h1>
                </div>

                <div className=''>
                    {selectedCourses.length > 0 && (
                        <div className='flex flex-col mt-5 bg-slate-200 p-1 mb-3 shadow-md' >
                            <h2 className='text-lg font-bold mb-2 text-black'>Selected Courses:</h2>
                            <ul className='flex gap-3'>
                                {/* {courses.filter(course => course.id === )} */}
                                {selectedCourses.map(course => (
                                    <li key={course.id} className='flex items-center justify-between bg-orange-400 w-32 h-10 p-1 mb-2 rounded-md'>
                                        <span className='text-white'>{course.code}</span>
                                        <IoMdClose onClick={() => handleClickCancel(course.id)} className='cursor-pointer text-black' />
                                    </li>
                                ))}
                            </ul>
                            <button className='text-right border-orange-400 text-orange-500' onClick={handleRegister}>Continue</button>
                        </div>
                    )}
                </div>

                <div className='flex justify-center overflow-x-auto w-[375px] md:w-full lg:min-w-[72rem]'>
                    <div className='overflow-y-auto max-h-[500px] shadow-md mb-4 w-full scrollable-section-hide'>
                        <table className='min-w-full divide-y divide-gray-300 shadow-md'>
                            <thead className='bg-gray-300 m-3 p-3 sticky top-0 z-10'>
                                <tr className='text-slate-500 font-extralight'>
                                    <th scope='col' className='px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Course Code</th>
                                    <th scope='col' className='px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Title</th>
                                    <th scope='col' className='px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Units</th>
                                    <th scope='col' className={`px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider ${student.stream !== 'full' && 'hidden'}`}>Semester</th>
                                    <th scope='col' className='px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Status</th>
                                    <th scope='col' className='px-2 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Options</th>
                                </tr>
                            </thead>

                            <tbody className='bg-orange-400 divide-y divide-gray-300'>
                                {courses.map((course) => (
                                    <tr key={course.code} className='text-xs uppercase'>
                                        <td className='px-2 py-2 whitespace-normal'>
                                            <div>{course.code}</div>
                                        </td>
                                        <td className='px-2 py-2 whitespace-normal'>
                                            <div>{course.title}</div>
                                        </td>
                                        <td className='px-2 py-2 whitespace-normal'>
                                            <div>{course.unit}</div>
                                        </td>
                                        <td className={`px-2 py-2 whitespace-normal ${student.stream !== 'full' && 'hidden'}`}>
                                            <div>{course.semester}</div>
                                        </td>
                                        <td className='px-2 py-2 whitespace-normal'>
                                            <div>{course.type}</div>
                                        </td>
                                        <td className='px-2 py-2 whitespace-normal'>
                                            <button className='bg-orange-500 w-14 h-8 rounded-md text-white' onClick={() => handleClickAdd(course)}>ADD</button>
                                        </td>
                                    </tr>
                                ))}
                            </tbody>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    )
}

export default CourseList