'use client'

import { useEffect, useState } from "react"
import cookies from 'js-cookie';
import { IoMdClose } from "react-icons/io";
import { API_BASE_URL } from "@/app/utils/app";

const CourseForm = ({ onClose }) => {
    const [u, setU] = useState('');
    const token = cookies.get('student');
    console.log(token)

    useEffect(() => {
        function downloadPdf() {
            fetch(`${API_BASE_URL}/courses/course_form/generate`, {
                headers: {
                    Authorization: `Bearer ${token}`
                }
            })
                .then(response => {
                    console.log(response, 'res')
                    return response.blob()
                })
                .then(blob => {
                    console.log(blob)
                    // Create a URL for the blob
                    const url = window.URL.createObjectURL(blob);
                    setU(url)
                    // setU(blob)
                    // Create a new anchor element
                    // const a = document.createElement('a');
                    // a.href = url;
                    // a.download = 'course_form.pdf';
                    // document.body.appendChild(a);
                    // // a.click();
                    // // a.remove();

                    // const iframe = document.querySelector('#frame')
                    // console.log(iframe, 'iframe')
                    // iframe.src = url;
                });
        }

        downloadPdf();

        return () => window.URL.revokeObjectURL(u)
    }, [])
    return (
        <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
            <div className="bg-white rounded-lg overflow-hidden shadow-xl transform transition-all max-w-lg w-full mt-20">
                <div className="px-4 py-5 sm:p-6">
                    <div className="flex justify-between items-center border-b border-gray-200 pb-5">
                        <h3 className="text-lg leading-6 font-medium text-gray-900">
                            Course Form
                        </h3>
                        <IoMdClose
                            className="cursor-pointer text-gray-400 hover:text-gray-600 transition ease-in-out duration-150"
                            onClick={onClose}
                            aria-label="Close modal"
                        />
                    </div>
                    {/* <div className='flex items-center justify-center max-w-md rounded-md p-5'> */}
                    <div className='flex items-center justify-center max-w-md rounded-md p-5'>
                        <iframe src={u} width="100%" height="500px"></iframe>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default CourseForm