// // "use client"
// import Image from 'next/image';
// import logo from "./img/logo.png";
// import Link from 'next/link';
// import StudentLogin from './forms/StudentLogin';

// const page = () => {
//   return (
//     <div className="p-3 xl:md:px-5 md:py-10 relative w-full bg-orange-400 mt-20 overflow-y-hidden">
//       <div className="flex flex-col md:flex-row divide-x-0 md:divide-x-2 divide-gray-200">
//         <div className="max-w-3xl mx-auto px-4 py-8">
//           <h2 className="text-2xl font-bold text-center mb-6">Application Guide</h2>
//           <p className="text-lg mb-4">Follow the steps below according to the type of application you're making: as a Professional or as a NID student.</p>

//           <div className="bg-orange-500 shadow-md rounded-lg p-6 mb-6 h-64 overflow-y-auto scrollbar-hide scrollable-section-hide">
//             <h3 className="text-xl font-semibold mb-4">For Professional programmes</h3>
//             <ul className="list-disc list-inside space-y-2">
//               <li><strong>Start Your Application:</strong> Click the "Professional" button on the main page. This will redirect you to the application page specifically for professionals.</li>
//               <li><strong>Application Submission and Payment:</strong> After submitting your application and once your admission has been accepted, you will be prompted to make the necessary payment to finalize your admission process.</li>
//               <li><strong>Access Your Dashboard:</strong> Once the admission and payment process is complete, return to the main page and log in as a student. You will then be able to access your student dashboard where you can find all relevant information and resources.</li>
//             </ul>
//           </div>

//           <div className="bg-orange-500 shadow-md rounded-lg p-6 h-72 overflow-y-auto scrollbar-hide scrollable-section-hide">
//             <h3 className="text-xl font-semibold mb-4">For NID programmes</h3>
//             <ul className="list-disc list-inside space-y-2">
//               <li><strong>Registration:</strong> Click on the "PUTME Registration" button. This action will start your application process for a degree program.</li>
//               <li><strong>Account Verification and Payment:</strong> After registering, you will need to verify your account and make the required payment as part of the application process.</li>
//               <li><strong>Admission Status and Letter Upload:</strong> Once you have logged in at <Link href='/aspirant/nid/login' className='text-orange-400'>login</Link>, wait for your admission status. If accepted, upload your admission letter through the provided portal and pay the required fees.</li>
//               <li><strong>Access Your Dashboard:</strong> After completing the above steps, you are now considered a full student. Log in to access your dashboard, where all essential resources and information are available to support your academic journey.</li>
//             </ul>
//           </div>
//         </div>
//         <div className="flex-1 p-8 flex flex-col justify-center items-center">
//           <StudentLogin />
//           {/* Other interactive elements if necessary */}
//           <div className="grid grid-cols-1 md:grid-cols-2 gap-10 mt-12">
//             <Link href="/aspirant/nid/putme_screening/register">
//               <div className="p-4 pt-5 flex flex-col items-center bg-white w-62 h-20 text-base font-semibold text-orange-500 rounded-md shadow-2xl m-2 cursor-pointer">
//                 <h1>Post UTME Registration</h1>
//                 <p className='text-black font-extralight'>Enter Here →</p>
//               </div>
//             </Link>
//             <Link href='/aspirant/professional/create'>
//               <div className="p-4 pt-5 flex flex-col items-center bg-white w-62 h-20 text-base font-semibold text-orange-500 rounded-lg shadow-lg m-2 cursor-pointer">
//                 <h1>Professional Application</h1>
//                 <p className='text-black font-extralight'>Enter Here →</p>
//               </div>
//             </Link>
//           </div>
//         </div>
//       </div>
//     </div>
//   );
// };

// export default page;


// "use client"
import Link from 'next/link';
import StudentLogin from './forms/StudentLogin';
import ApplicationGuide from './component/ApplicationGuide';

const Page = () => {

  return (
    <div className="p-5 xl:px-10 md:py-20 w-full bg-[#f3f3f3] mt-10 flex justify-center text-sm">
      <div className="flex flex-col md:flex-row bg-white shadow-lg max-w-6xl rounded-lg overflow-hidden">
        {/* Left Side - Application Guide */}
        <div className="flex-1 p-6 md:p-10 bg-orange-300 text-black">
          <ApplicationGuide />
        </div>

        {/* Right Side - Login Section */}
        <div className="flex-1 p-8 bg-white flex flex-col justify-center items-center">
          <StudentLogin />
          <div className="grid grid-cols-1 md:grid-cols-2 gap-10 mt-10 w-full text-sm">
            {/* <Link href="/aspirant/nid/putme_screening/register"> */}
            <Link href="/aspirant/nid/application/register">
              <div className="p-4 bg-orange-100 text-center rounded-lg shadow-md cursor-pointer">
                <h1 className="text-lg font-semibold">NID Application</h1>
                <p className="text-black font-light">Enter Here →</p>
              </div>
            </Link>
            <Link href='/aspirant/professional/create'>
              <div className="p-4 bg-orange-100 text-center rounded-lg shadow-md cursor-pointer">
                <h1 className="text-lg font-semibold">Professional Application</h1>
                <p className="text-black font-light">Enter Here →</p>
              </div>
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Page;
