import { cookies } from "next/headers";
import { NextResponse } from "next/server";
import { isTokenExpired } from "../utils/helper";

export function studentMiddleware(middleware) {
    return async (request, event) => {
        const student = request.nextUrl.pathname.startsWith('/student');
        // console.log(student, '<= pathname');

        if(!student) return middleware(request, event)

        const expired = isTokenExpired(cookies().get('student')?.value)
        if (expired) {
            console.log('token expired');
            return NextResponse.redirect(new URL('/', request.url));
        
        }
    }
}