import { cookies } from "next/headers";
import { NextResponse } from "next/server";
import { isTokenExpired } from "../utils/helper";

export function profAspirantMiddleware(middleware) {
    return async (request, event) => {
        const prof_aspirant = request.nextUrl.pathname === '/aspirant/professional' || request.nextUrl.pathname === '/aspirant/professional/apply'

        if(!prof_aspirant) return middleware(request, event)

        console.log(prof_aspirant, '<= pathname');
        const expired = isTokenExpired(cookies().get('prof_aspirant')?.value)
        if (expired) {
            console.log('token expired');
            return NextResponse.redirect(new URL('/aspirant/professional/login', request.url));
        
        }
    }
}