import { cookies } from "next/headers";
import { NextResponse } from "next/server";
import { isTokenExpired } from "../utils/helper";

export function aspirantMiddleware(middleware) {
    return async (request, event) => {
        const aspirant = request.nextUrl.pathname === '/aspirant/nid'

        if(!aspirant) return middleware(request, event)

        console.log(aspirant, '<= pathname');
        const expired = isTokenExpired(cookies().get('aspirant')?.value)
        if (expired) {
            console.log('token expired');
            return NextResponse.redirect(new URL('/aspirant/nid/login', request.url));
        
        }
    }
}