import { Inter, Montserrat } from "next/font/google";
import { cookies } from "next/headers"
import "./globals.css";
import Toast from "./component/Toast";
import Header from "./component/header";

const inter = Inter({ subsets: ["latin"] });
const montserrat = Montserrat({ subsets: ["latin"] })

export const metadata = {
  title: "TNM",
  description: "Student Portal",
};

export default function RootLayout({ children }) {
  const token = cookies().get('aspirant')?.value || cookies().get('prof_aspirant')?.value  

  return (
    <html lang="en" className="scrollable-section-hide">
      {/* <body className={inter.className}> */}
      <body className={montserrat.className}>
        <Header background_color='bg-white' account_section={token ? true : false} />
        {/* <Header background_color='bg-orange-500' /> */}
        <div>
          {children}
        </div>
        <Toast />
      </body>
    </html>
  );
}
