"use client"
import React, { useState } from 'react'
import Pages from '@/app/page'
import Link from 'next/link';
import cookies from 'js-cookie';
import { useRouter } from 'next/navigation'
import { studentLogin } from '@/app/utils/app'
import { notify } from '../utils/helper';

function Login() {
  const [formData, setFormData] = useState({
    adm_no: "",
    password: "",
  })
  const [loading, setLoading] = useState(false);

  const router = useRouter();

  const handleInputChange = (e) => {
    const { name, value } = e.target
    setFormData((PrevData) => ({
      ...PrevData,
      [name]: value
    }))
  }
  const handelsubmit = async (e) => {
    e.preventDefault();
    if (!formData.adm_no || !formData.password) return alert("Please fill in all fields");

    try {
      setLoading(true);
      const res = await studentLogin(formData);

      console.log(res.data.token)

      cookies.set('student_token', res.data.token);

      res.success && router.replace('/dashboard')

    } catch (error) {
      console.log(error);
      if (error.response?.data?.errors) notify('error', error.response.data.message)
      else notify('error', error.message);
    } finally {
      setLoading(false);
    }
    // console.log(formData);
  }
  return (
    <div>
      <form className='bg-white   w-96  max-h-[25rem] mt-8 pb-5' onSubmit={handelsubmit}>
        <div className='flex flex-col justify-center items-center pt-5 '>
          <h3 className='pt-4 text-3xl font-bold text-black'>Login</h3>
          <div className='pt-4 flex flex-col justify-center '>
            <input type="text" name="adm_no" id="" value={formData.adm_no} onChange={handleInputChange} className='border w-80 outline-none  rounded-lg p-3' placeholder='Admission No' />
            <input type="password" name="password" id="" value={formData.password} onChange={handleInputChange} className='border w-80 outline-none  rounded-lg mt-5 p-3' placeholder='Password' />
            <button className='  bg-orange-500 text-white cursor-pointer  w-80 outline-none font-semibold rounded-lg mt-5 p-3 '>Login</button>
          </div>
        </div>
        <div className='flex items-center gap-2 pl-9  pt-3 text-orange-500'>
          <a href="">Forgot Password?</a>
          <p className='text-xl'>😎 ←</p>
        </div>
      </form>
    </div>
  )
}

export default Login