"use client"
import { useEffect, useState } from 'react'
import logo from "../img/logo.png"
import Image from 'next/image';
import { pApplication } from "../utils/_actions";
import { notify } from '../utils/helper';
import { profApplication } from '../utils/app';
import cookies from 'js-cookie';
import { useRouter } from 'next/navigation';

const ProfApplicationForm = ({ programmes, data }) => {
    const router = useRouter()
    // const [selectedTalents, setSelectedTalents] = useState([]);
    const [showOtherInput, setShowOtherInput] = useState(false);
    const [formData, setFormData] = useState({
        // first_name: data.first_name,
        // last_name: data.last_name,
        middle_name: data.middle_name,
        email: data.email,
        phone: "",
        DOB: "",
        gender: '',
        programme_id: "",
        workplace: "",
        qualification: "",
        years_of_exp: 0,
        // stream: data.programme_stream,
        talents: []
    })
    console.log(data)
    const handleChange = (e) => {
        const { name, value } = e.target;
        setFormData((prevData) => ({
            ...prevData,
            [name]: value
        }));
    };


    // Handler for checkbox changes
    const handleTalentSelection = (e) => {
        const { value, checked } = e.target;
        // Toggle "Others" input field visibility
        if (value === 'others') {
            setShowOtherInput(checked);
        }

        if (checked) {
            setFormData(prev => ({
                ...prev,
                talents: [...prev.talents, value]
            }))
        } else {
            setFormData(prev => ({
                ...prev,
                talents: prev.talents.filter(talent => talent !== value)
            }))
        }
    };

    const handleOtherTalent = (e) => {
        setFormData(prev => ({
            ...prev,
            talents: [...prev.talents, e.target.value]
        }))
    }

    const handleSubmit = async (e) => {
        e.preventDefault()
        console.log(formData);
        const res = await profApplication(cookies.get('prof_aspirant'), formData, data.stream);

        res && notify('success', 'Application successful');
        if (res) router.push('/aspirant/professional');
    };

    return (
        <div className='bg-[#f3f3f3] min-h-screen flex justify-center items-center'>
            <form className='bg-orange-300 shadow-lg rounded-lg p-8 max-w-4xl w-full mt-32' onSubmit={handleSubmit}>
                <div className='flex flex-col items-center text-orange-900'>
                    {/* <Image src={logo} alt="logo" width={100} height={100} className="mb-4" /> */}
                    <h3 className='text-3xl font-black mb-5'>Application Form</h3>
                    <div className='grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 w-full mt-5'>
                        <div className='flex flex-col'>
                            <label htmlFor="FIRST NAME" className='pb-2'>First Name</label>
                            <input type="text" name="first_name" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={data.first_name} readOnly />
                        </div>
                        <div className='flex flex-col'>
                            <label>Last Name</label>
                            <input type="text" name="last_name" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={data.last_name} readOnly />
                        </div>
                        <div className='flex flex-col'>
                            <label>Middle Name</label>
                            <input type="text" name="middle_name" className='bg-orange-200 border w-full outline-none rounded-lg p-3' defaultValue={data.middle_name} readOnly />
                        </div>
                        <div className='flex flex-col'>
                            <label>Email</label>
                            <input type="email" name="email" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={data.email} readOnly />
                        </div>
                        <div className='flex flex-col'>
                            <label>Phone Number</label>
                            <input type="number" name="phone" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={data.phone} onChange={handleChange} />
                        </div>
                        <div className='flex flex-col'>
                            <label>Date Of birth</label>
                            <input type="date" name="DOB" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={formData.DOB} onChange={handleChange} />
                        </div>
                        <div className='flex flex-col'>
                            <label>Gender</label>
                            <select
                                className="w-full px-4 py-2 h-12 mt-1 text-orange-600 bg-orange-200 border rounded-lg outline-none focus:ring focus:ring-orange-200"
                                name="gender"
                                value={formData.gender}
                                onChange={handleChange}
                            >
                                <option>Choose your gender</option>
                                <option value={'male'}>Male</option>
                                <option value={'female'}>Female</option>
                                <option value={'other'}>Other</option>
                            </select>
                        </div>
                        <div className='flex flex-col'>
                            <label>WorkPlace</label>
                            <input type="text" name="workplace" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={formData.workplace} onChange={handleChange} />
                        </div>
                        <div className='flex flex-col'>
                            <label>Qualification</label>
                            <input type="text" name="qualification" className='bg-orange-200 border w-full outline-none rounded-lg p-3' value={formData.qualification} onChange={handleChange} />
                        </div>
                        <div className='flex flex-col'>
                            <label>Years of experience</label>
                            <select
                                className="w-full px-4 py-2 h-12 mt-1 text-orange-600 bg-orange-200 border rounded-lg outline-none focus:ring focus:ring-orange-200"
                                name="years_of_exp"
                                value={formData.years_of_exp}
                                onChange={handleChange}
                            >
                                <option>Choose years of experience</option>
                                {Array.from({ length: 5 }, (_, index) => (
                                    <option key={index} value={index + 1}>{index === 4 ? '5 and above' : index + 1}</option>
                                ))}
                            </select>
                        </div>
                        <div className='flex flex-col col-span-lg'>
                        <label htmlFor="talent" className='mb-2'>Talent (Select all that apply)</label>
                        <div className='flex flex-wrap justify-center'>
                            {['Singing', 'Acting', 'Poetry/Chanting', 'Ewi/Ijala', 'Writing', 'Comedy', 'Mimicking', ''].map((talent, index) => (
                                <div key={index} className='flex items-center mr-4 mb-2'>
                                    <input type="checkbox" id={`talent-${talent.toLowerCase()}`} name="talent" value={talent.toLowerCase()} className='mr-2 bg-orange-200' onChange={handleTalentSelection} />
                                    <label htmlFor={`talent-${talent.toLowerCase()}`}>{talent}</label>
                                </div>
                            ))}
                        </div>
                    </div>
                    {formData.talents.includes('others') && (
                        <div className='flex flex-col col-span-3'>
                            <label htmlFor="other_talent" className='mb-2'>Please specify your talent</label>
                            <input type="text" id="other_talent" name="talent" className='bg-orange-200 border w-full outline-none rounded-lg p-3' placeholder="Your talent" onChange={handleOtherTalent} />
                        </div>
                    )}

                    {/* Submit button area spans full width on all screen sizes */}
                    <div className='flex justify-center items-center w-full col-span-lg mt-5'>
                        <button type="submit" className='text-orange-900 bg-orange-500 font-semibold cursor-pointer w-full outline-none rounded-lg p-3'>
                            Proceed
                        </button>
                    </div>
                    </div>
                </div>
            </form>
        </div>
    );
}

export default ProfApplicationForm;