
function Table({ student }) {

  return (
    <div className="flex justify-center items-center my-12 w-full">
      {/* <div className="w-full max-w-4xl bg-white shadow-lg rounded-lg overflow-hidden border border-orange-300"> */}
      <div className="w-full bg-white shadow-lg rounded-lg overflow-hidden border border-orange-300">
        <div className="p-6">
          <h2 className="text-lg font-semibold text-orange-500 mb-4">Student Overview</h2>
          <div className="space-y-2 font-bold">
            {/* Student details as before */}
            <div className="flex justify-between">
              <h3 className="text-gray-700">Name:</h3>
              <span className="text-orange-500">{student.first_name} {student.last_name}</span>
            </div>
            <div className="flex flex-wrap justify-between">
              <h3 className="text-gray-700">Email:</h3>
              <span className="text-orange-500">{student.email}</span>
            </div>
            <div className="flex justify-between">
              <h3 className="text-gray-700">Gender:</h3>
              <span className="text-orange-500">{student.gender.split('')[0].toUpperCase() + student.gender.slice(1)}</span>
            </div>
            <div className="flex justify-between">
              <h3 className="text-gray-700">Admission Number:</h3>
              <span className="text-orange-500">{student.adm_no}</span>
            </div>
            <div className="flex justify-between">
              <h3 className="text-gray-700">Matric Number:</h3>
              <span className="text-orange-500">{student.matric_no}</span>
            </div>
            {
              student.jamb_reg &&
              (<div className="flex justify-between">
                <h3 className="text-gray-700">JAMB Reg No:</h3>
                <span className="text-orange-500">{student.jamb_reg}</span>
              </div>)
            }
          </div>
        </div>
      </div>
    </div>
  );
}

export default Table;


