'use client'
import { profLogin } from '@/app/utils/app';
import { pLogin } from '@/app/utils/_actions'
import { useRouter } from 'next/navigation';
import { useRef, useState } from 'react';
import cookies from 'js-cookie';
import logo from '@/app/img/logo.png'
import Image from 'next/image';
import { notify } from '@/app/utils/helper';

const page = () => {

  const [error, setError] = useState('');
  const formRef = useRef();
  const router = useRouter();
  // const [loading, setLoading] = useState(false);

  const handelsubmit = async (e) => {
    e.preventDefault();
    setError('')

    try {
      const res = await profLogin({
        email: formRef.current.email.value,
        password: formRef.current.password.value,
      });

      cookies.set('prof_aspirant', res.data.token);

      // res.success && router.push('/aspirant/professional')
      if(res.success) window.location.href = '/aspirant/professional'

    } catch (error) {
      console.log(error.response)
      // if (error.response?.data?.errors) return setError(error.response.data.message)
      // setError(error.message)
      if (error.response?.data?.errors) return notify('error', error.response.data.message)
      notify('error', error.message)
    } finally {
      console.log('done')
    }
    // console.log(formRef.current);
  }

  return (
    <div className="bg-[#f3f3f3] flex flex-col items-center justify-center min-h-screen">
      {error && <div className="text-red-500">{error}</div>}
      <form ref={formRef} className='bg-orange-300 shadow-md rounded-lg p-6 w-full max-w-md mt-8 pb-5' onSubmit={handelsubmit}>
        <div className='w-full flex flex-col items-center'>
          {/* <Image src={logo} alt="Company Logo" width={120} height={120} className="mb-4" /> */}
          <h3 className='text-3xl font-bold text-orange-900'>Login</h3>
          <div className='w-full flex flex-col items-center px-4 mt-4'>
            <input type="email" name="email" id="email" className='w-full border outline-none rounded-lg p-3' placeholder='Email' />
            <input type="password" name="password" id="password" className='w-full border outline-none rounded-lg mt-5 p-3' placeholder='Password' />
            <button className='w-full bg-orange-500 cursor-pointer rounded-lg mt-5 p-3 text-orange-900'>Login</button>
          </div>
        </div>
        <div className='w-full text-right pr-6 gap-2 mt-7'>
          <a href="#" className='text-orange-900 underline decoration-orange-500'>Forgot Password?</a>
        </div>
      </form>
    </div>
  );
}

export default page