'use client'

import { verifyTutionFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import cookies from 'js-cookie';
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";

const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_ids = searchParams.get('fee_ids');
    const stream = searchParams.get('stream');
    const [status, setStatus] = useState(null);
    const [error, setError] = useState(''); // To store error messages
    const router = useRouter();
    const ref = useRef(true);
    
    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyTutionFeePayment(cookies.get('prof_aspirant'), fee_ids, stream, reference);
                console.log(verification);
                if(verification.success) {
                    setStatus('success');
                    router.push('/');
                } else {
                    setStatus('fail');
                }
            } catch (error) {
                console.error(error);
                setError(error.response?.data?.message || error.message); // Store the error message
                setStatus('error');
            }
        };

        if (ref.current) verify();

        return () => {
            ref.current = false; // Clean up function
        };
    }, []);

    useEffect(() => {
        // This useEffect handles notifications separately.
        if (status === 'success') {
            notify('success', 'Payment successful');
        } else if (status === 'error' && error) {
            notify('error', error);
        }
    }, [status, error]); // Depend on status and error

    return (
        <div>
            {status === 'success' ? (
                <p>Payment successful. Redirecting...</p>
            ) : status === 'fail' ? (
                <p>Verification failed</p>
            ) : (
                <Preloader />
            )}
        </div>
    );
}

export default page;
