'use client'

import { getAcceptanceFee, getIDCardFee, getProfile, getSchoolFee, verifyEmailAndGetFormFee } from '@/app/utils/app';
import jwt from 'jsonwebtoken';
import { redirect } from 'next/navigation';
import { useEffect, useRef, useState } from 'react';
// import { cookies } from 'next/headers';
import cookies from 'js-cookie';
import AcceptancePayButton from '../component/AcceptancePayButton';
import TuitionPayButton from '../component/TuitionPayButton';
import BothPayButton from '../component/BothPayButton';
import { notify } from '@/app/utils/helper';

function page() {
    const [me, setMe] = useState(null);
    const [choosenFee, setChoosenFee] = useState({
        acceptance: false,
        school_fee: false
        // acceptance: '',
        // school_fee: ''
    });
    const [feesToPay, setFeesToPay] = useState({
        acceptance: '',
        school_fee: '',
        ID_card: '',
        split: false
    })
    const [total, setTotal] = useState(0);


    // can't use ref again because I need a quick effect on the UI without any event
    const chooseRef = useRef();

    const token = cookies.get('prof_aspirant');
    useEffect(() => {
        const fetchMe = async () => {
            try {
                const meData = await getProfile(token);
                setMe(meData.data);
            } catch (error) {
                console.error("Failed to fetch profile", error);
                // Handle error appropriately
            }
        };

        fetchMe();
    }, []);

    console.log(me, 'MMMMEEEEE');

    useEffect(() => {
        const total = Object.values(feesToPay).reduce((acc, fee) => acc + (fee.amount || 0), 0);
        setTotal(total);
    }, [feesToPay]);

    useEffect(() => {

        if (choosenFee.acceptance) {
            const fetchAcceptanceFee = async () => {
                try {
                    const fee = await getAcceptanceFee(token, me.stream);

                    if (!fee) throw new Error('failed to get fee')
                    console.log(fee, 'ffff')
                    setFeesToPay(prev => ({
                        ...prev,
                        acceptance: fee.data
                    }))

                    // setTotal(total + fee.data.amount);
                } catch (error) {
                    console.log(error)
                    if (error.response.data.errors) return notify('error', error.response.data.message)
                    return notify('error', error.message)
                }
            }

            fetchAcceptanceFee()
        } else if (choosenFee.acceptance === false) {
            setFeesToPay(prev => ({
                ...prev,
                acceptance: ''
            }))

            // setTotal(total - feesToPay.acceptance.amount)
            // setTotal(feesToPay.acceptance.amount - total)
        }

        if (choosenFee.school_fee) {
            const fetchSchoolFee = async () => {
                try {
                    const fee = await getSchoolFee(token, me.stream, feesToPay.split);
                    console.log(fee)
                    const card = await getIDCardFee(token);

                    if (!fee || !card) throw new Error()

                    setFeesToPay(prev => ({
                        ...prev,
                        school_fee: fee.data,
                        ID_card: card.data
                    }))

                    // setTotal(total + fee.data.amount)

                } catch (error) {
                    console.log(error)
                    if (error.response.data.errors) return notify('error', error.response.data.message)
                    return notify('error', error.message)
                }
            }

            fetchSchoolFee();
        } else {
            setFeesToPay(prev => ({
                ...prev,
                school_fee: ''
            }))

            // setTotal(total - feesToPay.school_fee.amount)
        }
    }, [choosenFee, feesToPay.split]);

    console.log(feesToPay, 'feestopay')
    console.log(total)

    const handleChoose = (e) => {
        const { name, checked } = e.target
        console.log(name, checked)

        setChoosenFee(prev => ({
            ...prev,
            [name]: checked
        }));
    }

    const handleContinue = (e) => {
        e.preventDefault()

        const { acceptance, school_fee } = chooseRef.current
        // console.log(chooseRef.current[name].value);

        setChoosenFee({
            acceptance: acceptance.checked,
            school_fee: school_fee.checked
        })
    }

    console.log(choosenFee, 'state')

    return (

        <div className='bg-[#f3f3f3] min-h-screen flex flex-col items-center justify-center px-3'>
            {/* <div className="w-full flex justify-center mb-8">
                <Image src={logo} alt="logo" width={160} height={160} />
            </div> */}

            <h1 className="text-xl font-semibold mb-8">Choose Your Fees</h1>

            <form className='mb-6 flex gap-10 justify-center'>
                <label className="flex items-center">
                    <input type='checkbox' name='acceptance' onChange={handleChoose} className="mr-2" />
                    Acceptance Fee
                </label>
                <label className="flex items-center">
                    <input type='checkbox' name='school_fee' onChange={handleChoose} className="mr-2" />
                    School Fee
                </label>
            </form>

            {(choosenFee.acceptance || choosenFee.school_fee) ? (
                <div className='w-full max-w-md p-4 bg-orange-400 shadow-lg rounded-lg'>
                    <h2 className='text-lg font-semibold text-center mb-4'>Payment Summary</h2>
                    <div className='space-y-4'>
                        {choosenFee.acceptance && (
                            <div className="flex justify-between">
                                <p>Acceptance Fee:</p>
                                <p className="font-bold">₦{feesToPay.acceptance?.amount}</p>
                            </div>
                        )}
                        {choosenFee.school_fee && (
                            <>
                                <div className="flex justify-between">
                                    <p>ID Card:</p>
                                    <p className="font-bold">₦{feesToPay.ID_card?.amount}</p>
                                </div>
                                <div className="flex justify-between">
                                    <p>School Fee:</p>
                                    <p className="font-bold">₦{feesToPay.school_fee?.amount}</p>
                                </div>
                            </>
                        )}
                        {choosenFee.school_fee && (
                            <div className="flex justify-between items-center">
                                <div className="flex items-center">
                                    <input
                                        type="checkbox"
                                        name="split"
                                        onChange={(e) => setFeesToPay(prev => ({ ...prev, split: e.target.checked }))}
                                        className="mr-2 checked:bg-orange-400"
                                    />
                                    <p className='text-xs'>Part Payment (Pay 60% of School Fee)</p>
                                </div>
                            </div>
                        )}
                        <div className="flex justify-between font-bold">
                            <p>Total:</p>
                            <p>₦{total}</p>
                        </div>
                        <div className='mt-4 flex justify-end space-x-4'>
                            {(choosenFee.acceptance && !choosenFee.school_fee) && <AcceptancePayButton token={token} stream={me.stream} />}
                            {(choosenFee.school_fee && !choosenFee.acceptance) && <TuitionPayButton token={token} split={feesToPay.split} stream={me.stream} />}
                            {(choosenFee.acceptance && choosenFee.school_fee) && (
                                <BothPayButton token={token} split={feesToPay.split} stream={me.stream} />
                            )}
                        </div>
                    </div>
                </div>
            ) : (
                <p>Please select at least one fee to proceed with payment.</p>
            )}
        </div>

    )
}

export default page