'use client'
import { verifyFormFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import cookies from 'js-cookie';
import { useEffect, useRef, useState } from "react";
import Loader from "@/app/component/Loader";
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";

const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_id = searchParams.get('fee_id');
    const stream = searchParams.get('stream');
    const [status, setStatus] = useState(null);
    const [error, setError] = useState('');
    const router = useRouter();
    const ref = useRef(true);

    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyFormFeePayment(fee_id, stream, reference);
                console.log(verification);
                if (verification.success) {
                    setStatus('success');
                    router.push('/aspirant/professional/login');
                } else {
                    setStatus('fail');
                }
            } catch (error) {
                console.error(error);
                setError(error.message); // We're capturing error message in state.
                setStatus('error');
            }
        };

        if (ref.current) verify();

        return () => {
            ref.current = false;
        };
    }, []);

    useEffect(() => {
        if (status === 'success') {
            notify('success', 'Payment successful');
        } else if (status === 'error' && error) {
            notify('error', error);
        }
    }, [status, error]); // This effect runs when `status` or `error` changes.

    return (
        <div>
            {status === 'success' || status === 'fail' ?
                status === 'success' ?
                    <p>Payment successful. Redirecting...</p>
                    :
                    <p>Verification failed</p>
                :
                <Preloader />
            }
        </div>
    );
}

export default page;

