
import { verifyEmailAndGetFormFee } from '@/app/utils/app';
import jwt from 'jsonwebtoken';
import FormPayButton from '../../component/FormPayButton';
import logo from '@/app/img/logo.png'
import Image from 'next/image';

const fetchFormFee = async (token) => {
    const fee = await verifyEmailAndGetFormFee(token);

    return fee.data;
}

async function page({ searchParams }) {
    const { fee } = await fetchFormFee(searchParams.token);
    let decoded = jwt.decode(searchParams.token);

    console.log(decoded);
    console.log(fee);


    return (
        <div className="bg-[#f3f3f3] flex justify-center items-center min-h-screen font-serif">
            <div className='shadow-lg rounded-lg bg-orange-300 p-8 md:min-w-[30rem] w-full max-w-4xl text-center'>
                {/* <Image src={logo} alt="logo" width={150} height={150} className="mx-auto" /> */}
                <h1 className='text-xl text-orange-900 font-bold my-5'>Application Form Fee</h1>
                <h5 className='text-orange-900 text-left font-light text-3xl ml-8'>{decoded.last_name} {decoded.first_name} {decoded.middle_name}</h5>
                <div className='mt-4 px-8'>
                    <div className='flex justify-between items-center text-orange-900'>
                        <h3>Application Fee:</h3>
                        <p className='font-bold'>₦{fee.amount}</p>
                    </div>
                    <div className='flex justify-between items-center text-orange-900 mb-4'>
                        <h3>Charges:</h3>
                        <p className='font-bold'>₦{fee.charges}</p>
                    </div>
                    <div className='flex justify-between items-center text-orange-900'>
                        <h3>Total:</h3>
                        <p className='font-bold'>₦{fee.amount + fee.charges}</p>
                    </div>
                    <div className='border-b my-10'></div>
                </div>
                <FormPayButton data={decoded} />
            </div>
        </div>
    );
}

export default page;
