'use client'

import { verifyAcceptanceFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import cookies from 'js-cookie';
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";


const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_id = searchParams.get('fee_id');
    const stream = searchParams.get('stream');
    const [status, setStatus] = useState(null);
    const [error, setError] = useState(''); // To store error message
    const router = useRouter();
    const ref = useRef(true);
    const token = cookies.get('prof_aspirant');
    
    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyAcceptanceFeePayment(token, fee_id, stream, reference);
                console.log(verification);
                if (verification.success) {
                    setStatus('success');
                    router.replace('/aspirant/professional');
                } else {
                    setStatus('fail');
                }
            } catch (error) {
                console.error(error);
                setError(error.response?.data?.message || error.message); // Capturing error message
                setStatus('error');
            }
        };

        if (ref.current) verify();

        return () => {
            ref.current = false;
        };
    }, []);

    useEffect(() => {
        // This effect handles side effects based on status.
        if (status === 'success') {
            notify('success', 'Payment successful');
        } else if (status === 'error' && error) {
            notify('error', error);
        }
    }, [status, error]); // Reacts to changes in status or error.

    return (
        <div>
            {status === 'success' ? (
                <p>Payment successful. Redirecting...</p>
            ) : status === 'fail' ? (
                <p>Verification failed</p>
            ) : (
                <Preloader />
            )}
        </div>
    );
}

export default page;
