'use client'
import { create } from '@/app/utils/_actions';
import { createAccount } from '@/app/utils/app';
import Link from 'next/link';
import { useRef, useState, useTransition } from 'react';
import swal from 'sweetalert2';

const ApplicationForm = ({ programmes }) => {
    const [isPending, startTransition] = useTransition();
    const formRef = useRef();
    const [error, setError] = useState('');

    const handleCreate = async (e) => {
        e.preventDefault();
        setError('')
        try {
            const create = await createAccount({
                first_name: formRef.current.first_name.value,
                last_name: formRef.current.last_name.value,
                middle_name: formRef.current.middle_name.value,
                email: formRef.current.email.value,
                phone: formRef.current.phone.value,
                stream: formRef.current.stream.value,
            });

            if (!create) throw new Error('Failed to create account');

            swal.fire({
                position: "top-end",
                icon: "success",
                title: "Kindly check your mail to continue",
                showConfirmButton: false,
                timer: 3000
            });

            // formRef.current.first_name.value = '',
            formRef.current.reset();
        } catch (error) {
            if (error.response?.data?.errors) return setError(error.response.data.message)
            setError(error.message);
        }
    }

    return (
        <div>
            {/* <h2 className='text-xl font-extralight text-center pt-10 text-orange-300'>Apply</h2> */}
            {error && <div className="text-red-500">{error}</div>}
            <form ref={formRef} onSubmit={(e) => startTransition(() => handleCreate(e))} className='grid grid-cols-1 sm:grid-cols-2 mx-4 sm:mx-20 mt-12 gap-4 sm:gap-8'>
                <input type="text" name='first_name' placeholder='First Name*' className='bg-orange-200 outline-none border rounded-sm shadow p-3 w-full h-12' />
                <input type="text" name='last_name' placeholder='Last Name*' className='bg-orange-200 outline-none border rounded-sm shadow p-3 w-full h-12' />
                <input type="text" name='middle_name' placeholder='Middle Name' className='bg-orange-200 outline-none border rounded-sm shadow p-3 w-full h-12' />
                <input type="email" name='email' placeholder='Email*' className='bg-orange-200 outline-none border rounded-sm shadow p-3 w-full h-12' />
                <input type="number" name='phone' placeholder='Phone*' className='bg-orange-200 outline-none border rounded-sm shadow p-3 w-full h-12' />
                <select className="bg-orange-200 outline-none border text-slate-400 rounded-sm shadow p-3 w-full h-12" name="stream" id="stream">
                    <option>Choose programme</option>
                    {programmes.map(prog => (
                        <option key={prog.id} value={prog.stream} className='bg-orange-200'>{prog.stream.charAt(0).toUpperCase() + prog.stream.slice(1)} Professional Certificate</option>
                    ))}
                </select>
                <button className='bg-orange-500 text-orange-100 w-full sm:w-auto mt-5 rounded-md h-10 col-span-full font-semibold'>{isPending ? 'Please wait...' : 'Continue'}</button>
                <div className='flex gap-2 w-full text-orange-900 justify-right pt-3'>
                    <p className='font-medium'>Already applied?</p>
                    <Link href="/aspirant/professional/login" className='underline docoration-orange-500'>Login here</Link>
                </div>
            </form>
        </div>
    );
}

export default ApplicationForm