'use client'

import { useEffect, useState } from 'react';
import cookies from 'js-cookie';
import { getIDCardFee, getNIDAcceptanceFee, getNIDSchoolFee } from '@/app/utils/app';
import AcceptancePayButton from '../component/AcceptancePayButton';
import TuitionPayButton from '../component/TuitionPayButton';
import BothPayButton from '../component/BothPayButton';

function Fee() {
    const [choosenFee, setChoosenFee] = useState({ acceptance: false, school_fee: false });
    const [feesToPay, setFeesToPay] = useState({ acceptance: '', school_fee: '', ID_card: '', split: false })
    const [total, setTotal] = useState(0);
    const token = cookies.get('aspirant');

    useEffect(() => {
        async function fetchFees() {
            try {
                if (choosenFee.acceptance) {
                    const acceptanceFee = await getNIDAcceptanceFee(token);
                    setFeesToPay(prev => ({ ...prev, acceptance: acceptanceFee.data }));
                } else {
                    setFeesToPay(prev => ({ ...prev, acceptance: '' }));
                }

                if (choosenFee.school_fee) {
                    const schoolFee = await getNIDSchoolFee(token, feesToPay.split);
                    const idCardFee = await getIDCardFee(token);
                    setFeesToPay(prev => ({ ...prev, school_fee: schoolFee.data, ID_card: idCardFee.data }));
                } else {
                    setFeesToPay(prev => ({ ...prev, school_fee: '', ID_card: '' }));
                }
            } catch (error) {
                console.error("Failed to fetch fees: ", error);
            }
        }

        fetchFees();
    }, [choosenFee, feesToPay.split]);

    useEffect(() => {
        const total = Object.values(feesToPay).reduce((acc, fee) => acc + (fee.amount || 0), 0);
        setTotal(total);
    }, [feesToPay]);

    const handleChoose = (e) => {
        const { name, checked } = e.target;
        setChoosenFee(prev => ({ ...prev, [name]: checked }));
    };

    return (
        <div className='flex flex-col items-center justify-center my-8 text-orange-900'>
            <h1 className="text-orange-900 text-xl font-semibold mb-8">Fees</h1>
            <form className='mb-6'>
                <div className='flex gap-6'>
                    <label className="flex items-center">
                        <input type='checkbox' name='acceptance' onChange={handleChoose} className="mr-2 text-orange-900" />
                        Acceptance Fee
                    </label>
                    <label className="flex items-center">
                        <input type='checkbox' name='school_fee' onChange={handleChoose} className="mr-2 text-orange-900" />
                        School Fee
                    </label>
                </div>
            </form>
            {choosenFee.acceptance || choosenFee.school_fee ? (
                <div className='w-full max-w-md p-4 bg-orange-400 shadow-md rounded-lg'>
                    <h2 className='text-lg font-semibold text-center mb-4'>Payment Summary</h2>
                    <div className='space-y-2'>
                        {choosenFee.acceptance && <p>Acceptance Fee: ₦{feesToPay.acceptance?.amount}</p>}
                        {choosenFee.school_fee && (
                            <>
                                <p>ID Card: ₦{feesToPay.ID_card?.amount}</p>
                                <p>School Fee: ₦{feesToPay.school_fee?.amount}</p>
                            </>
                        )}
                        <p className='font-bold'>Total: ₦{total}</p>
                        <div className='mt-4'>
                            {choosenFee.acceptance && !choosenFee.school_fee && <AcceptancePayButton token={token} />}
                            {choosenFee.school_fee && !choosenFee.acceptance && <TuitionPayButton token={token} split={feesToPay.split} />}
                            {(choosenFee.acceptance && choosenFee.school_fee) && (
                                <BothPayButton token={token} split={feesToPay.split} />
                            )}
                        </div>
                    </div>
                </div>
            ) : (
                <p>Please select at least one fee to proceed with payment.</p>
            )}
        </div>
    );
}

export default Fee;
