'use client'

import { payNBothFee } from "@/app/utils/app"
import { useRouter } from "next/navigation";
import { useState, useTransition } from "react";
import cookies from 'js-cookie';
import { notify } from "@/app/utils/helper";

const BothPayButton = ({ token, split }) => {
    const [isPending, startTransition] = useTransition();
    const [error, setError] = useState('');
    const router = useRouter();

    const pay = async () => {
        try {
            setError(null);
            const res = await payNBothFee(token, split);
            console.log(res)
            router.replace(res.data.url);
        } catch (err) {
            console.error('Payment error:', err);
            if (err.response.data.message) notify('error', err.response.data.message)
            else notify('error', 'Payment failed ☹️. Please try again later');
        }
    }

    return (
        <div>
            <div className='flex gap-4 '>
                <button className='shadow-md w-32 h-10 rounded-md'>Cancel</button>
                <button className='shadow-md w-32 h-10 rounded-md text-white bg-orange-500' onClick={() => startTransition(pay)}>{isPending ? 'Processing...' : 'Pay'}</button>
            </div>
            {error && <div className="text-red-500">{error}</div>}
        </div>
    )
}

export default BothPayButton