import React from 'react';
import { FaUpload } from 'react-icons/fa';

function AdmissionSection({ profile, onUploadClick }) {
    return (
        <div>
            <h2 className="text-2xl font-semibold mb-4">Admission Details</h2>
            <p className="mb-4">Here you'll find information regarding your admission. Ensure to review all the details carefully.</p>
            {!profile.adm_letter_mimetype && (
                <button 
                    onClick={onUploadClick} 
                    className="mt-4 inline-flex items-center px-4 py-2 bg-orange-500 text-white rounded hover:bg-orange-600 focus:outline-none focus:ring"
                >
                    <FaUpload className="mr-2" />
                    Upload Admission Letter
                </button>
            )}
        </div>
    );
}

export default AdmissionSection;
