
"use client";
import { useEffect, useState } from "react";
import Validation from "@/app/component/Validation";
import PUTMEScreeningFee from "../../component/PUTMEScreeningFee";
import PartApplicationFee from "../../component/PartApplicationFee";
import Link from "next/link";
import InputField from "@/app/component/InputField";
import SelectField from "@/app/component/SelectField";
import FileField from "@/app/component/FileField";
import { registerAndPartApplicationFee, registerAndPayPutmeFee } from "@/app/utils/app";
import { notify } from "@/app/utils/helper";
import { useRouter } from "next/navigation";
import { FaPlus, FaPlusCircle, FaTimes } from "react-icons/fa";

function Page() {
  const [activeTab, setActiveTab] = useState("fulltime");
  // const [showFee, setShowFee] = useState(false);
  const [manualOLevel, setManualOLevel] = useState([]);
  const [formData, setFormData] = useState({
    fulltime: {
      first_name: "",
      last_name: "",
      middle_name: "",
      email: "",
      phone: "",
      DOB: "",
      gender: "",
      jamb_reg: "",
      jamb_result: "",
      o_level: "",
    },
    parttime: {
      first_name: "",
      last_name: "",
      middle_name: "",
      gender: "",
      DOB: "",
      state_of_origin: "",
      lga: "",
      phone: "",
      email: "",
      address: "",
      passport: "",
      o_level: "",
    },
  });
  const router = useRouter();
  // console.log(formData, 'formData', activeTab)
  // console.log(manualOLevel)
  const handleTabSwitch = (tab) => {
    setActiveTab(tab);

    setManualOLevel([]);

    setFormData((prevFormData) => ({
      ...prevFormData,
      [tab]: {
        ...Object.keys(prevFormData[tab]).reduce((acc, key) => {
          acc[key] = "";
          return acc;
        }, {}),
      },
    }));
  }

  // useEffect(() => {
  //   const resetFormData = {
  //     first_name: "",
  //     last_name: "",
  //     middle_name: "",
  //     email: "",
  //     phone: "",
  //     DOB: "",
  //     gender: "",
  //     ...((activeTab === "fulltime") ? {
  //       jamb_reg: "",
  //       jamb_result: "",
  //       o_level: "",
  //     } : {
  //       state_of_origin: "",
  //       lga: "",
  //       address: "",
  //       passport: "",
  //       o_level: "",
  //     })
  //   };
  //   setFormData((prevFormData) => ({
  //     ...prevFormData,
  //     [activeTab]: resetFormData,
  //   }));
  //   setManualOLevel([]); // Reset manual O-Level fields when switching tabs
  // }, [activeTab]);

  const handleChange = (e) => {
    const { name, value, files } = e.target;
    const tabData = formData[activeTab];

    if (name === "passport" || name === 'o_level' || (activeTab === "fulltime" && (name === "o_level" || name === "jamb_result"))) {
      const file = files[0];
      if (file) {
        setFormData({
          ...formData,
          [activeTab]: {
            ...tabData,
            [name]: file,
          },
        });
      }
    } else {
      setFormData({
        ...formData,
        [activeTab]: {
          ...tabData,
          [name]: value,
        },
      });
    }
  };

  const addOLevelField = () => {
    if(!manualOLevel.length) return setManualOLevel([...manualOLevel, { subject: "", grade: "" }]);
    
    // Only add a new field if the last one is filled
    const lastField = manualOLevel[manualOLevel.length - 1];
    if (lastField && lastField.subject && lastField.grade) {
      setManualOLevel([...manualOLevel, { subject: "", grade: "" }]);
    }
  };

  const handleOLevelChange = (index, e) => {
    const { name, value } = e.target;
    const updatedOLevel = [...manualOLevel];
    updatedOLevel[index][name] = value;
    setManualOLevel(updatedOLevel);
  };

  const removeOLevelField = (index) => {
    const updatedOLevel = manualOLevel.filter((_, i) => i !== index);
    setManualOLevel(updatedOLevel);
  };

  const handleSubmit = async (e, stream) => {
    e.preventDefault();
    // setShowFee(!showFee);
    try {
      let res;
      if (stream === 'fulltime') {
        // res = await registerAndPayPutmeFee(formData[activeTab]);

        setFormData((prevFormData) => ({
          ...prevFormData,
          [stream]: {
            ...Object.keys(prevFormData[stream]).reduce((acc, key) => {
              acc[key] = "";
              return acc;
            }, {}),
          },
        }));
        throw new Error('Fulltime registration is not available at the moment. Please contact the for additional information');
      } else {
        const data = { ...formData[stream], manual_o_level: manualOLevel }
        res = await registerAndPartApplicationFee(data);
      }

      if (!res) throw new Error('Application failed');

      notify('success', res.message)
      setTimeout(() => router.push('/aspirant/nid/login'), 3000)
    } catch (error) {
      console.log(error)
      if (error.response?.data?.errors || error.response?.data?.message) return notify('error', error.response.data.message)
      notify('error', error.message)
    }
  };

  return (
    <div className="bg-[#f3f3f3] flex justify-center min-h-screen">
      <div className="shadow-lg bg-orange-300 rounded-sm p-4 sm:p-7 m-4 sm:m-32 w-full max-w-screen-lg">
        {activeTab === "fulltime" && <h1 className="font-bold mb-5 text-2xl pt-3 text-center text-orange-900">Post UTME Screening Form</h1>}
        {activeTab === "parttime" && <h1 className="font-bold mb-5 text-2xl pt-3 text-center text-orange-900">Part Time Application Form</h1>}

        <div className='flex justify-around py-3 bg-orange-100 rounded-lg mb-6'>
          <button
            className={`px-4 py-2 rounded ${activeTab === "fulltime" ? "bg-orange-400 text-white" : "text-orange-500"}`}
            onClick={() => handleTabSwitch("fulltime")}
          >
            Full-Time
          </button>
          <button
            className={`px-4 py-2 rounded ${activeTab === "parttime" ? "bg-orange-400 text-white" : "text-orange-500"}`}
            onClick={() => handleTabSwitch("parttime")}
          >
            Part-Time
          </button>
        </div>

        <form key={activeTab} onSubmit={(e) => handleSubmit(e, activeTab)}>
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
            {/* Common Fields */}
            <InputField name="first_name" label="First Name" onChange={handleChange} value={formData[activeTab].first_name} />
            <InputField name="last_name" label="Last Name" onChange={handleChange} value={formData[activeTab].last_name} />
            <InputField name="middle_name" label="Middle Name" onChange={handleChange} value={formData[activeTab].middle_name} />
            <InputField name="email" label="Email Address" type="email" onChange={handleChange} value={formData[activeTab].email} />
            <InputField name="phone" label="Phone Number" type="tel" onChange={handleChange} value={formData[activeTab].phone} />
            <InputField name="DOB" label="Date of Birth" type="date" onChange={handleChange} value={formData[activeTab].DOB} />
            <SelectField name="gender" label="Gender" options={["male", "female", "other"]} onChange={handleChange} value={formData[activeTab].gender} />
            <InputField name="course" label="Course" value="Broadcast Journalism" disabled />
            <InputField name="college" label="College" value="Social Science" disabled />


            {/* Full-Time Specific Fields */}
            {activeTab === "fulltime" && (
              <>
                <InputField name="jamb_reg" label="JAMB Registration Number" onChange={handleChange} value={formData[activeTab].jamb_reg} />
                <FileField name="jamb_result" label="Upload JAMB Result" onChange={handleChange} />
                <FileField name="o_level" label="Upload O-Level Result" onChange={handleChange} />
              </>
            )}

            {/* Part-Time Specific Fields */}
            {activeTab === "parttime" && (
              <span>
                <>
                  <InputField name="state_of_origin" label="State of Origin" onChange={handleChange} value={formData[activeTab].state_of_origin} />
                  <InputField name="lga" label="LGA" onChange={handleChange} value={formData[activeTab].lga} />
                  <InputField name="address" label="Address" onChange={handleChange} value={formData[activeTab].address} />
                  <FileField name="passport" label="Upload Passport" onChange={handleChange} />
                  <FileField name="o_level" label="Upload O-Level Result" onChange={handleChange} />

                  <div className="col-span-2 mt-5">
                    <div className="flex justify-between items-center">
                      <h2 className="font-semibold mb-2">Manual O-Level Entry</h2>
                      <div>
                        <button
                          type="button"
                          // className="bg-orange-400 text-white p-3 rounded mt-3 flex items-center justify-center"
                          onClick={addOLevelField}
                        >
                          <FaPlusCircle color="#ff8800" size={20} />
                        </button>

                      </div>
                    </div>
                    {manualOLevel.map((field, index) => (
                      <div key={index} className="flex gap-2 mb-2">
                        <InputField
                          name="subject"
                          placeholder="Subject"
                          hideLabel
                          value={field.subject}
                          onChange={(e) => handleOLevelChange(index, e)}
                        />
                        <InputField
                          name="grade"
                          placeholder="Grade"
                          hideLabel
                          value={field.grade}
                          onChange={(e) => handleOLevelChange(index, e)}
                        />
                        <button type="button" onClick={() => removeOLevelField(index)} className="text-red-500">
                          <FaTimes size={16} />
                        </button>
                      </div>
                    ))}

                  </div>
                </>
              </span>
            )}
          </div>

          <div className="flex justify-center mt-10">
            <button type="submit" className="bg-orange-400 text-white px-10 py-2 rounded">
              Continue
            </button>
          </div>

          <div className="flex gap-2 w-full justify-end pt-3">
            <p className="font-medium">Already applied?</p>
            <Link href="/aspirant/nid/login" className="underline text-orange-500">
              Login here
            </Link>
          </div>
        </form>
      </div>
    </div>
  );
}

export default Page;
