import Image from "next/image"
import { cookies } from "next/headers"
import Link from "next/link";
import { getProfile } from "@/app/utils/app";
import InfoCard from "../component/InfoCard";
import { redirect } from "next/navigation";

export const dynamic = 'force-dynamic';

const getMe = async (token) => {
    const user = await getProfile(token);

    return user.data;
}

const page = async () => {
    const token = cookies().get('aspirant')?.value;
    console.log(token)

    if(!token) redirect('/aspirant/nid/login')

    const profile = await getMe(token);
    console.log(profile)

    return (
        <div className='bg-[#f3f3f3] min-h-screen flex flex-col items-center font-serif text-white pt-32'>
            {/* <div className="pt-5">
                <Image src={logo} alt="logo" width={160} height={160} />
            </div> */}
            {profile ? (
                <div className='flex flex-col  bg-orange-300 text-black w-full max-w-md rounded-md p-5 mt-10 min-h-72'>
                    {
                        profile.status === 'pending' && (
                            <>
                                <h3 className='text-2xl font-semibold'>Welcome, {profile.first_name}!</h3>
                                <p className="mt-4">Your application is currently being processed. The screening date will be communicated soon. Please keep checking back for updates.</p>
                            </>
                        )
                    }
                    {profile.status === 'accepted' && (
                        <InfoCard profile={profile} />
                    )}
                    {profile.status !== 'pending' && profile.status !== 'accepted' && (
                        <p>Unfortunately, you have not been given admission.</p>
                    )}
                </div>
            ) : <p>Unable to retrieve profile information. Please try again later.</p>
            }
        </div>
    );
    
}

export default page